$fa=0.5;
$fs=0.5;

box_w = 80;										// box width
box_h = 60;										// box height
box_d = 40;										// box deepness
box_th = 2;										// box thickness

cover_w = box_w - 2 * box_th - 0.5;		// box cover width
cover_h = box_h - 2 * box_th - 0.5;			// box cover height
cover_d = box_th;							// box cover deepness

overlap = 1.5;									// overlap between box and box cover

display_w = 23.5;							// display width
display_h = 10.6;								// display height
display_x = 13;
display_y = 12;

cut_th = box_th + 2;						// cutting element thickness

on_switch_w = 19.2;						// on/off switch width
on_switch_h = 13;							// on/off switch height
on_switch_x = box_w - display_w/2 - on_switch_w;
on_switch_y = display_y;

va_switch = 6.4;								// volt/amp switch diameter

cable_hole = 3;								// cables hole diameter

support_w = 9;								// cover support width
support_h = 9;									// cover support height
support_d = box_d - box_th;		// cover support deepness

screw_d = 3;									// screws diameter
screw_pos = 4;								// screw position from external box walls
screw_dep = 4;									// screw hole deepness

/********************************************************************************************/
// cover

translate([0, 10, 0]) difference()
{
	cube([cover_w, cover_h, cover_d]);
	translate([screw_pos-overlap, screw_pos-overlap, -1]) cylinder(d=3, h = cut_th);
	translate([cover_w - (screw_pos-overlap), cover_h - (screw_pos-overlap), -1]) cylinder(d=3, h = cut_th);
	translate([cover_w/5-13, cover_h/3*2 - 10, 0.4]) linear_extrude(height=1.7) text("eleneasy.com", size=7, font=":Bold");
}

/********************************************************************************************/
// box

translate([0, -box_h, 0])
{
	difference()
	{
		cube([box_w, box_h, box_d]);
		translate([box_th, box_th, box_th])
			cube([box_w - 2*box_th, box_h - 2*box_th, box_d]);
		translate([display_x, display_y, -1])
			cube([display_w, display_h, 2+box_th]);
		translate([on_switch_x, on_switch_y, -1])
			cube([on_switch_w, on_switch_h, box_th+2]);
		translate([display_x + display_w/2, display_y + box_h/2, -1])
			cylinder(d=va_switch, box_th+2);
		translate([on_switch_x + on_switch_w/2, display_y + box_h/2, -1])
			cylinder(d=screw_d, box_th+2);
		translate([10.2, box_h-15, 1.6]) rotate([180, 0, 0])  linear_extrude(height=1.7) text("V        A", size=5, font=":Bold");
	}
	difference()
	{
		cube([support_w, support_h, support_d]);
		translate([screw_pos, screw_pos, support_d-screw_dep]) cylinder(d=screw_d, h=screw_dep+1);
	}
	translate([box_w-support_w, 0, 0]) cube([support_w, support_h, support_d]);
	translate([0, box_h - support_h, 0]) cube([support_w, support_h, support_d]);
	translate([box_w-support_w, box_h - support_h, 0]) difference()
	{
		cube([support_w, support_h, support_d]);
		translate([screw_pos, screw_pos, support_d-screw_dep]) cylinder(d=screw_d, h=screw_dep+1);
	}
}

