#include "DHT.h"

#define DHT_DIGITAL_PIN 2

//Uncomment only the kind of sensor being used
//#define DHTTYPE DHT11
#define DHTTYPE DHT22

// create and initialize the static DHT object
DHT dht(DHT_DIGITAL_PIN, DHTTYPE);

// create static variables to store readings
float h=0.0;    // humidity
float t=0.0;    // temperature in celsius
float f=0.0;    // temperature in Fahrenheit


void setup() {
    // put your setup code here, to run once:
    Serial.begin(9600);
    dht.begin();
}

void measure()
{
    h = dht.readHumidity();
    t = dht.readTemperature();
    f = dht.readTemperature(true);

    // provide the output on the serial monitor
    Serial.print("Humidity: ");
    Serial.print(h);
    Serial.println("%");
    Serial.print("Temp: ");
    Serial.print(t);
    Serial.print(" C ; ");
    Serial.print(f);
    Serial.println(" F");
}

void loop() {
    // put your main code here, to run repeatedly:
    measure();
    delay(2000);
}
