$fa=0.5;
$fs=0.5;

/*******************************************************************************
 *		Dimension settings
 *
 *		Choose between Depth=1, 2, 3 and Width=1, 2, 3, 4
 *
 *		Scaling parameters are:
 *					for Depth:	50
 *					for Width:  50.8
 ******************************************************************************/
Depth = 2;
Width = 1.5;
/******************************************************************************
 *      What to print
 *
 *      Choose between  Body = 1;  and  wings = 0
 ******************************************************************************/
print_choice = 1;




height_1 = 229;
height_2 = 196;
b_width = 50.8;
width = b_width * Width;
deep = 50 * Depth;
thick = 2;
height_0 = 15;


if (print_choice == 1)
{
    // front panel
    difference()
    {
        cube([width, height_2 - 2* thick, thick]);
        translate([width/4, -thick, 25]) rotate([-90, 0, 0]) cylinder(h = height_2, d=3.5);
        translate([width/4*3, -thick, 25]) rotate([-90, 0, 0]) cylinder(h = height_2, d=3.5);
    	
        HEIGHT = height_2 - 2*thick;
        WIDTH = width;
        //***********************************************************************
        // add here any other hole that is needed on the front panel
        //
        // use HEIGHT and WIDTH as dimensions of the panel
        //***********************************************************************
    
        translate([WIDTH/2 - 46.2/2, 4*HEIGHT/5 - 28/2, -1]) cube([46.2, 27, thick+2]);
        translate([WIDTH/2 - 46.2/2, 2*HEIGHT/5 - 28/2, -1]) cube([46.2, 27, thick+2]);
        translate([WIDTH/2 - 46.2/2, 3*HEIGHT/5 - 28/2, -1]) cube([46.2, 27, thick+2]);
        translate([10, 57, 1]) cube([WIDTH-20, HEIGHT-75, thick]);
        translate([WIDTH/3, HEIGHT/5, -1]) cylinder(d=12.4, h=thick+2);      // switch
        translate([2*WIDTH/3, HEIGHT/5, -1]) cylinder(d=12.2, h=thick+2);      // fuse
    }


    // body
    translate([0, 0, thick]) cube([width, thick, deep]); 
    translate([4, 0, 0]) difference()
    {
        translate([0, 0, thick]) cube([thick, height_2 - 2*thick, deep]);
    
        S_HEIGHT = height_2 - 2*thick;
        S_WIDTH = deep;         
        //************************************************************************
        // add here any screw hole needed to support the PCB
        //
        // use S_HEIGHT and S_WIDTH as dimensions of the side panel
        //************************************************************************
        translate([-1, S_HEIGHT-20, S_WIDTH-5]) rotate([0, 90, 0]) cylinder(d=3, h=thick+2);
        translate([-1, S_HEIGHT-20-93, S_WIDTH-5]) rotate([0, 90, 0]) cylinder(d=3, h=thick+2);
        translate([-1, S_HEIGHT-20, S_WIDTH-5-63]) rotate([0, 90, 0]) cylinder(d=3, h=thick+2);
        translate([-1, S_HEIGHT-20-93, S_WIDTH-5-63]) rotate([0, 90, 0]) cylinder(d=3, h=thick+2);
        
    }
    translate([width-thick-4, 0, thick]) cube([thick, height_2 - 2*thick, height_0]);
    translate([0, height_2 - 3*thick, thick]) cube([width, thick, deep]);
}
else 
{
    // supporting wings
    difference()
    {
        cube([width, (height_1 - height_2)/2 + thick, 50]);
        translate([-1, -thick, thick]) cube([width+2, (height_1 - height_2)/2 + thick, 50]);
        for(i= [0:1:Width-1])
        {
            translate([width/2, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
        }
    }
    translate([0, (height_1 - height_2 - 2*thick)/2 + 20, 0]) difference()
    {
        cube([width, (height_1 - height_2)/2 + thick, 50]);
        translate([-1, -thick, thick]) cube([width+2, (height_1 - height_2)/2 + thick, 50]);
        for(i= [0:1:Width-1])
        {
            translate([width/2, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
        }
   }
}