$fa=0.5;
$fs=0.5;

/*******************************************************************************
 *		Dimension settings
 *
 *		Choose between Depth=1, 2, 3 and Width=1, 2, 3, 4
 *
 *		Scaling parameters are:
 *					for Depth:	50
 *					for Width:  50.8
 ******************************************************************************/
Depth = 3;
Width = 3;
/******************************************************************************
 *      What to print
 *
 *      Choose between  Body = 1;  and  wings = 0
 ******************************************************************************/
print_choice = 1;



/* do not modify the value of the following constants */
height_1 = 229;
height_2 = 196;
b_width = 50.8;
width = b_width * Width;
deep = 50 * Depth;
thick = 2;
height_0 = 15;
/*   end constants   */


if (print_choice == 1)
{
    // front panel
    difference()
    {
        cube([width, height_2 - 2* thick, thick]);
        translate([width/4, -thick, 25]) rotate([-90, 0, 0]) cylinder(h = height_2, d=3.5);
        translate([width/4*3, -thick, 25]) rotate([-90, 0, 0]) cylinder(h = height_2, d=3.5);

		HEIGHT = height_2 - 2*thick;
		WIDTH = width;
        //***********************************************************************
        // add here any other hole that is needed on the front panel
        //
        // use HEIGHT and WIDTH as dimensions of the panel
        //***********************************************************************
        ref_x = WIDTH/2;
        ref_y = HEIGHT/2;
        
        translate([ref_x, ref_y - 5, -1]) cylinder(d=7.2, h=4);     // transpose pot
        translate([ref_x, ref_y - 15, -1]) cylinder(d=2, h=4);
        translate([ref_x+50, ref_y+75, -1]) cylinder(d=7.2, h=4);   // CV mix Aux1 pot
        translate([ref_x+25, ref_y+75, -1]) cylinder(d=7.2, h=4);   // CV mix Aux2 pot
        translate([ref_x, ref_y+75, -1]) cylinder(d=7.2, h=4);      // CV mix pulse pot
        translate([ref_x-25, ref_y+75, -1]) cylinder(d=7.2, h=4);   // CV mix Triangle pot
        translate([ref_x-50, ref_y+75, -1]) cylinder(d=7.2, h=4);   // CV mix ramp/saw pot
        translate([ref_x+50, ref_y-55, -1]) cylinder(d=7.2, h=4);   // FM depth
        translate([ref_x+50, ref_y+42.5, -1]) cylinder(d=9.2, h=4); // CV mix aux1 jack
        translate([ref_x+25, ref_y+42.5, -1]) cylinder(d=9.2, h=4); // CV mix aux2 jack
        translate([ref_x, ref_y+42.5, -1]) cylinder(d=9.2, h=4);    // CV mix pulse jack
        translate([ref_x-25, ref_y+42.5, -1]) cylinder(d=9.2, h=4); // CV mix triangle jack
        translate([ref_x-50, ref_y+42.5, -1]) cylinder(d=9.2, h=4); // CV mix ramp/saw jack
        translate([ref_x+50, ref_y+12.5, -1]) cylinder(d=9.2, h=4); // Aux1 input
        translate([ref_x+25, ref_y+12.5, -1]) cylinder(d=9.2, h=4); // Aux2 input
        translate([ref_x-50, ref_y+12.5, -1]) cylinder(d=9.2, h=4); // Mix output
        translate([ref_x+50, ref_y-22.5, -1]) cylinder(d=9.2, h=4); // FM CV
        translate([ref_x+25, ref_y-22.5, -1]) cylinder(d=9.2, h=4); // Sync
        translate([ref_x, ref_y-35, -1]) cylinder(d=9.2, h=4);    // expo 1
        translate([ref_x-25, ref_y-22.5, -1]) cylinder(d=9.2, h=4); // expo 2
        translate([ref_x-50, ref_y-22.5, -1]) cylinder(d=9.2, h=4); // expo 3
        translate([ref_x+50, ref_y-82.5, -1]) cylinder(d=9.2, h=4); // triangle output
        translate([ref_x+25, ref_y-82.5, -1]) cylinder(d=9.2, h=4); // saw/ramp output
        translate([ref_x, ref_y-82.5, -1]) cylinder(d=9.2, h=4);    // square output
        translate([ref_x-25, ref_y-82.5, -1]) cylinder(d=9.2, h=4); // sine output
        translate([ref_x-50, ref_y-82.5, -1]) cylinder(d=9.2, h=4); // pulse output
        translate([ref_x+25, ref_y-55, -1]) cylinder(d=6.2, h=4);   // ramp/saw switch
        translate([ref_x-50, ref_y-55, -1]) cylinder(d=7.2, h=4);   // PWM
    }


    // body
    translate([0, 0, thick]) cube([width, thick, 50]);
    translate([0, 0, thick]) cube([4+thick, thick, deep]);
    translate([4, 0, 0]) difference()
    {
        translate([0, 0, thick]) cube([thick, height_2 - 2*thick, deep]);

		S_HEIGHT = height_2 - 2*thick;
		S_WIDTH =  deep;
        //************************************************************************
        // add here any screw hole needed to support the PCB
        //
        // use S_HEIGHT and S_WIDTH as dimensions of the side panel
        //************************************************************************
        translate([-1, 10, 15]) rotate([0, 90, 0]) cylinder(d=4, h=4);
        translate([-1, 10, 145]) rotate([0, 90, 0]) cylinder(d=4, h=4);
        translate([-1, 180, 15]) rotate([0, 90, 0]) cylinder(d=4, h=4);
        translate([-1, 180, 145]) rotate([0, 90, 0]) cylinder(d=4, h=4);
    }
    translate([width-thick-4, 0, thick]) cube([thick, height_2 - 2*thick, height_0]);
    translate([0, height_2 - 3*thick, thick]) cube([width, thick, 50]);
    translate([0, height_2 - 3*thick, thick]) cube([4+thick, thick, deep]);
}
else
{
    // supporting wings
    difference()
    {
        cube([width, (height_1 - height_2)/2 + thick, 50]);
        translate([-1, -thick, thick]) cube([width+2, (height_1 - height_2)/2 + thick, 50]);
        for(i= [0:1:Width-1])
        {
            translate([b_width/2+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
        }
    }
    translate([0, (height_1 - height_2 - 2*thick)/2 + 20, 0]) difference()
    {
        cube([width, (height_1 - height_2)/2 + thick, 50]);
        translate([-1, -thick, thick]) cube([width+2, (height_1 - height_2)/2 + thick, 50]);
        for(i= [0:1:Width-1])
        {
            translate([b_width/2+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
        }
   }
}
