$fa=0.5;
$fs=0.5;

/*******************************************************************************
 *		Dimension settings
 *
 *		Choose between Depth=1, 2, 3 and Width=1, 2, 3, 4
 *
 *		Scaling parameters are:
 *					for Depth:	50
 *					for Width:  50.8
 ******************************************************************************/
Depth = 1;
Width = 1;
/******************************************************************************
 *      What to print
 *
 *      Choose between  Body = 1;  and  wings = 0
 ******************************************************************************/
print_choice = 1;



/* do not modify the value of the following constants */
height_1 = 229;
height_2 = 196;
b_width = 50.8;
width = b_width * Width;
deep = 50 * Depth;
thick = 2;
height_0 = 15;
/*   end constants   */


if (print_choice == 1)
{
    // front panel
    difference()
    {
        cube([width, height_2 - 2* thick, thick]);
        translate([width/4, -thick, 25]) rotate([-90, 0, 0]) cylinder(h = height_2, d=3.5);
        translate([width/4*3, -thick, 25]) rotate([-90, 0, 0]) cylinder(h = height_2, d=3.5);

		HEIGHT = height_2 - 2*thick;
		WIDTH = width;
        //***********************************************************************
        // add here any other hole that is needed on the front panel
        //
        // use HEIGHT and WIDTH as dimensions of the panel
        //***********************************************************************


    }


    // body
    translate([0, 0, thick]) cube([width, thick, deep]);
    translate([4, 0, 0]) difference()
    {
        translate([0, 0, thick]) cube([thick, height_2 - 2*thick, deep]);

		S_HEIGHT = height_2 - 2*thick;
		S_WIDTH =  deep;
        //************************************************************************
        // add here any screw hole needed to support the PCB
        //
        // use S_HEIGHT and S_WIDTH as dimensions of the side panel
        //************************************************************************


    }
    translate([width-thick-4, 0, thick]) cube([thick, height_2 - 2*thick, height_0]);
    translate([0, height_2 - 3*thick, thick]) cube([width, thick, deep]);
}
else
{
    // supporting wings
    difference()
    {
        cube([width, (height_1 - height_2)/2 + thick, 50]);
        translate([-1, -thick, thick]) cube([width+2, (height_1 - height_2)/2 + thick, 50]);
        for(i= [0:1:Width-1])
        {
            translate([b_width/2+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
        }
    }
    translate([0, (height_1 - height_2 - 2*thick)/2 + 20, 0]) difference()
    {
        cube([width, (height_1 - height_2)/2 + thick, 50]);
        translate([-1, -thick, thick]) cube([width+2, (height_1 - height_2)/2 + thick, 50]);
        for(i= [0:1:Width-1])
        {
            translate([b_width/2+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
        }
   }
}
