$fa=0.5;
$fs=0.5;

/*******************************************************************************
 *		Dimension settings
 *
 *		Choose between Depth=1, 2, 3 and Width=1, 2, 3, 4
 *
 *		Scaling parameters are:
 *					for Depth:	50
 *					for Width:  50.8
 ******************************************************************************/
Depth = 2.6 ;
Width = 4;
/******************************************************************************
 *      What to print
 *
 *      Choose between:
 *           Full mod = 2
 *           Body only = 1
 *           wings only = 0
 ******************************************************************************/
print_choice = 2;



/* do not modify the value of the following constants */
height_1 = 229;
height_2 = 196;
b_width = 50.8;
width = b_width * Width;
deep = 50 * Depth;
thick = 2;
height_0 = 15;
/*   end constants   */


if ((print_choice == 1) || (print_choice == 2))     // body only or full body
{
    // front panel
    difference()
    {
        cube([width, height_2 - 2* thick, thick]);
        translate([width/4, -thick, 25]) rotate([-90, 0, 0]) cylinder(h = height_2, d=3.5);
        translate([width/4*3, -thick, 25]) rotate([-90, 0, 0]) cylinder(h = height_2, d=3.5);

		HEIGHT = height_2 - 2*thick;
		WIDTH = width;
        //***********************************************************************
        // add here any other hole that is needed on the front panel
        //
        // use HEIGHT and WIDTH as dimensions of the panel
        //***********************************************************************
       translate([0, 5, 0])
        {
        // VU meter
        translate([WIDTH/2+25, HEIGHT-151, -1]) cylinder(d=9.2, h=2*thick);    // through
        translate([WIDTH/2-25, HEIGHT-151, -1]) cylinder(d=9.2, h=2*thick);    // input
        translate([WIDTH/2, HEIGHT-151, -1]) cylinder(d=6.2, h=2*thick);    // range
        translate([WIDTH/2, 63, -1]) cylinder(d=5.5, h=2*thick);    // LED 1
        translate([WIDTH/2, 12+63, -1]) cylinder(d=5.5, h=2*thick);    // LED 2
        translate([WIDTH/2, 2*12+63, -1]) cylinder(d=5.5, h=2*thick);    // LED 3
        translate([WIDTH/2, 3*12+63, -1]) cylinder(d=5.5, h=2*thick);    // LED 4
        translate([WIDTH/2, 4*12+63, -1]) cylinder(d=5.5, h=2*thick);    // LED 5
        translate([WIDTH/2, 5*12+63, -1]) cylinder(d=5.5, h=2*thick);    // LED 6
        translate([WIDTH/2, 6*12+63, -1]) cylinder(d=5.5, h=2*thick);    // LED 7
        translate([WIDTH/2, 7*12+63, -1]) cylinder(d=5.5, h=2*thick);    // LED 8
        translate([WIDTH/2, 8*12+63, -1]) cylinder(d=5.5, h=2*thick);    // LED 9
        translate([WIDTH/2, 9*12+63, -1]) cylinder(d=5.5, h=2*thick);    // LED 10
        
        // DC mixer 1
        translate([0, HEIGHT-96, 0])
        {
            translate([WIDTH-WIDTH/8, 20, -1]) cylinder(d=7.2, h=2*thick);    // offset
            translate([WIDTH-2*WIDTH/8, 20, -1]) cylinder(d=9.2, h=2*thick);    // output
            translate([WIDTH-3*WIDTH/8, 20, -1]) cylinder(d=9.2, h=2*thick);    // inverse output
            translate([WIDTH-WIDTH/8, 45, -1]) cylinder(d=9.2, h=2*thick);    // input 1 jack
            translate([WIDTH-2*WIDTH/8, 45, -1]) cylinder(d=9.2, h=2*thick);    // input 2 jack
            translate([WIDTH-3*WIDTH/8, 45, -1]) cylinder(d=9.2, h=2*thick);    // input 3 jack
            translate([WIDTH-WIDTH/8, 70, -1]) cylinder(d=7.2, h=2*thick);    // input 1 pot
            translate([WIDTH-2*WIDTH/8, 70, -1]) cylinder(d=7.2, h=2*thick);    // input 2 pot
            translate([WIDTH-3*WIDTH/8, 70, -1]) cylinder(d=7.2, h=2*thick);    // input 3 pot
        }
        
        // DC mixer 2
         translate([-WIDTH/2, HEIGHT-96, 0])
        {
            translate([WIDTH-3*WIDTH/8, 20, -1]) cylinder(d=7.2, h=2*thick);    // offset
            translate([WIDTH-WIDTH/8, 20, -1]) cylinder(d=9.2, h=2*thick);    // output
            translate([WIDTH-2*WIDTH/8, 20, -1]) cylinder(d=9.2, h=2*thick);    // inverse output
            translate([WIDTH-WIDTH/8, 45, -1]) cylinder(d=9.2, h=2*thick);    // input 1 jack
            translate([WIDTH-2*WIDTH/8, 45, -1]) cylinder(d=9.2, h=2*thick);    // input 2 jack
            translate([WIDTH-3*WIDTH/8, 45, -1]) cylinder(d=9.2, h=2*thick);    // input 3 jack
            translate([WIDTH-WIDTH/8, 70, -1]) cylinder(d=7.2, h=2*thick);    // input 1 pot
            translate([WIDTH-2*WIDTH/8, 70, -1]) cylinder(d=7.2, h=2*thick);    // input 2 pot
            translate([WIDTH-3*WIDTH/8, 70, -1]) cylinder(d=7.2, h=2*thick);    // input 3 pot
        }
        
        // Glide 1
        translate([0, HEIGHT-101, 0])
        {
            translate([WIDTH-3*WIDTH/10, 0, -1]) cylinder(d=7.2, h=2*thick);    // time pot
            translate([WIDTH-4*WIDTH/10, 0, -1]) cylinder(d=6.2, h=2*thick);    // range switch
            translate([WIDTH-WIDTH/10, 0, -1]) cylinder(d=9.2, h=2*thick); // input
            translate([WIDTH-2*WIDTH/10, 0, -1]) cylinder(d=9.2, h=2*thick); // output
        }
        
         // Glide 2
        translate([-WIDTH/2, HEIGHT-101, 0])
        {
            translate([WIDTH-2*WIDTH/10, 0, -1]) cylinder(d=7.2, h=2*thick);    // time pot
            translate([WIDTH-WIDTH/10, 0, -1]) cylinder(d=6.2, h=2*thick);    // range switch
            translate([WIDTH-3*WIDTH/10, 0, -1]) cylinder(d=9.2, h=2*thick);   // input
            translate([WIDTH-4*WIDTH/10, 0, -1]) cylinder(d=9.2, h=2*thick);   // output
        }
        
        // Limitator 1
        translate([0, HEIGHT-176, 0])
        {
            translate([WIDTH-WIDTH/8, 0, -1]) cylinder(d=9.2, h=2*thick); // input
            translate([WIDTH-2*WIDTH/8, 0, -1]) cylinder(d=7.2, h=2*thick); // Bias
            translate([WIDTH-3*WIDTH/8, 0, -1]) cylinder(d=9.2, h=2*thick); // Output
        }
        
         // Limitator 2
        translate([-WIDTH/2, HEIGHT-176, 0])
        {
            translate([WIDTH-WIDTH/8, 0, -1]) cylinder(d=9.2, h=2*thick); // input
            translate([WIDTH-2*WIDTH/8, 0, -1]) cylinder(d=7.2, h=2*thick); // Bias
            translate([WIDTH-3*WIDTH/8, 0, -1]) cylinder(d=9.2, h=2*thick); // Output
        }
        
        // Sample and Hold 1
        translate([0, HEIGHT-151, 0])
        {
            translate([WIDTH-WIDTH/8, 25, -1]) cylinder(d=9.2, h=2*thick); // input
            translate([WIDTH-WIDTH/8, 0, -1]) cylinder(d=9.2, h=2*thick); // trigger
            translate([WIDTH-2*WIDTH/8, 0, -1]) cylinder(d=9.2, h=2*thick); // through
            translate([WIDTH-2*WIDTH/8, 25, -1]) cylinder(d=9.2, h=2*thick); // Output
            translate([WIDTH-3*WIDTH/8, 25, -1]) cylinder(d=6.2, h=2*thick); // on/off
        }
        
         // Sample and Hold 2
        translate([-WIDTH/2, HEIGHT-151, 0])
        {
            translate([WIDTH-2*WIDTH/8, 25, -1]) cylinder(d=9.2, h=2*thick); // input
            translate([WIDTH-2*WIDTH/8, 0, -1]) cylinder(d=9.2, h=2*thick); // trigger
            translate([WIDTH-3*WIDTH/8, 0, -1]) cylinder(d=9.2, h=2*thick); // through
            translate([WIDTH-3*WIDTH/8, 25, -1]) cylinder(d=9.2, h=2*thick); // Output
            translate([WIDTH-WIDTH/8, 25, -1]) cylinder(d=6.2, h=2*thick); // on/off
        }  
        }
    }


    // body
    difference()
    {
        translate([0, 0, thick]) cube([width, thick, 50]);
        if (print_choice != 2)
        {
            translate([12, -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
            translate([width-12, -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
        }
    }
    translate([0, 0, thick]) cube([4+thick, thick, deep]);
    translate([4, 0, 0]) difference()
    {
        translate([0, 0, thick]) cube([thick, height_2 - 2*thick, deep]);

		S_HEIGHT = height_2 - 2*thick;
		S_WIDTH =  deep;
        //************************************************************************
        // add here any screw hole needed to support the PCB
        //
        // use S_HEIGHT and S_WIDTH as dimensions of the side panel
        //************************************************************************
        translate([-1, 30, 30]) rotate([0, 90, 0]) cylinder(d=4, h=thick+2);
        translate([-1, 160, 30]) rotate([0, 90, 0]) cylinder(d=4, h=thick+2);
        translate([-1, 30, 120]) rotate([0, 90, 0]) cylinder(d=4, h=thick+2);
        translate([-1, 160, 120]) rotate([0, 90, 0]) cylinder(d=4, h=thick+2);
    }
    translate([width-thick-4, 0, thick]) cube([thick, height_2 - 2*thick, height_0]);
    difference()
    {
        translate([0, height_2 - 3*thick, thick]) cube([width, thick, 50]);
        if (print_choice != 2)
        {    
            translate([12, height_2 -3*thick -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
            translate([width-12, height_2 -3*thick -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
        }
    }
    translate([0, height_2 - 3*thick, thick]) cube([4+thick, thick, deep]);
}
else if (print_choice == 0)         // wings only
{
    // supporting wings
    difference()
    {
        cube([width, (height_1 - height_2)/2 + thick, 50]);
        translate([-1, -thick, thick]) cube([width+2, (height_1 - height_2)/2 + thick, 50]);
        for(i= [0:1:Width-1])
        {
            if(Width==1.5 || Width==2.5 || Width==3.5)
            {
                translate([b_width/4*3+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
            }
            else
            {
            translate([b_width/2+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
            }
        }
        translate([12, (height_1 - height_2)/2 -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
        translate([width-12, (height_1 - height_2)/2 -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
    }
    
    
    translate([0, (height_1 - height_2 - 2*thick)/2 + 20, 0])
    {
        difference()
        {
            cube([width, (height_1 - height_2)/2 + thick, 50]);
            translate([-1, -thick, thick]) cube([width+2, (height_1 - height_2)/2 + thick, 50]);
            for(i= [0:1:Width-1])
            {
                if(Width==1.5 || Width==2.5 || Width==3.5)
                {
                    translate([b_width/4*3+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
                }
                else
                {
                    translate([b_width/2+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
                }
            }
            translate([12, (height_1 - height_2)/2 -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
            translate([width-12, (height_1 - height_2)/2 -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
        }
    }

    // alignment cylinders
    if (print_choice != 2)
    translate([10, -10, 0]) cylinder(d=7.5, h=2*thick);
    translate([30, -10, 0]) cylinder(d=7.5, h=2*thick);
    translate([50, -10, 0]) cylinder(d=7.5, h=2*thick);
    translate([70, -10, 0]) cylinder(d=7.5, h=2*thick);
}

if (print_choice == 2)      // add wings to full body
{
    // supporting wings
    translate([0, -((height_1 - height_2)/2 + thick), 0]) difference()
    {
        cube([width, (height_1 - height_2)/2 + thick, 50]);
        translate([-1, -thick, thick]) cube([width+2, (height_1 - height_2)/2 + thick, 50]);
        for(i= [0:1:Width-1])
        {
            if(Width==1.5 || Width==2.5 || Width==3.5)
            {
                translate([b_width/4*3+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
            }
            else
            {
            translate([b_width/2+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
            }
        }
    }
    
    translate([0, (height_1 - height_2 - 2*thick)/2, 0])
    {
        rotate([0, 0, 180]) translate([-width, -height_2, 0]) difference()
        {
            cube([width, (height_1 - height_2)/2 + thick, 50]);
            translate([-1, -thick, thick]) cube([width+2, (height_1 - height_2)/2 + thick, 50]);
            for(i= [0:1:Width-1])
            {
                if(Width==1.5 || Width==2.5 || Width==3.5)
                {
                    translate([b_width/4*3+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
                }
                else
                {
                    translate([b_width/2+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
                }
            }
        }
    }
   
 }
 