$fa=0.5;
$fs=0.5;

/*******************************************************************************
 *		Dimension settings
 *
 *		Choose between Depth=1, 2, 3 and Width=1, 2, 3, 4
 *
 *		Scaling parameters are:
 *					for Depth:	50
 *					for Width:  50.8
 ******************************************************************************/
Depth = 2;
Width = 1;
/******************************************************************************
 *      What to print
 *
 *      Choose between  Body = 1;  and  wings = 0
 ******************************************************************************/
print_choice = 1;



/* do not modify the value of the following constants */
height_1 = 229;
height_2 = 196;
b_width = 50.8;
width = b_width * Width;
deep = 50 * Depth;
thick = 2;
height_0 = 15;
/*   end constants   */


if (print_choice == 1)
{
    // front panel
    difference()
    {
        cube([width, height_2 - 2* thick, thick]);
        translate([width/4, -thick, 25]) rotate([-90, 0, 0]) cylinder(h = height_2, d=3.5);
        translate([width/4*3, -thick, 25]) rotate([-90, 0, 0]) cylinder(h = height_2, d=3.5);

		HEIGHT = height_2 - 2*thick;
		WIDTH = width;
        //***********************************************************************
        // add here any other hole that is needed on the front panel
        //
        // use HEIGHT and WIDTH as dimensions of the panel
        //***********************************************************************
        translate([WIDTH/2, 165, -1]) cylinder(d=6.5, h=4);  // keyboard jack
        translate([WIDTH/2 -7.5, 157.5, 1]) cube([15, 15, 2]);
        translate([WIDTH/2, 99, -1]) cylinder(d=9.2, h=4);   // CV
        translate([WIDTH/2, 66, -1]) cylinder(d=9.2, h=4);   // gate
        translate([WIDTH/2, 33, -1]) cylinder(d=9.2, h=4);   // trigger
    }


    // body
    difference()
    {
        translate([0, 0, thick]) cube([width, thick, 50]);
        translate([12, -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
        translate([width-12, -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
    }
    translate([0, 0, thick]) cube([4+thick, thick, deep]);
    translate([4, 0, 0]) difference()
    {
        translate([0, 0, thick]) cube([thick, height_2 - 2*thick, deep]);

		S_HEIGHT = height_2 - 2*thick;
		S_WIDTH =  deep;
        //************************************************************************
        // add here any screw hole needed to support the PCB
        //
        // use S_HEIGHT and S_WIDTH as dimensions of the side panel
        //************************************************************************

        translate([-1, 40, 25]) rotate([0, 90, 0]) cylinder(d=3.5, h=4);
        translate([-1, 40, 92]) rotate([0, 90, 0]) cylinder(d=3.5, h=4);
        translate([-1, 144, 25]) rotate([0, 90, 0]) cylinder(d=3.5, h=4);
        translate([-1, 144, 92]) rotate([0, 90, 0]) cylinder(d=3.5, h=4);
    }
    translate([width-thick-4, 0, thick]) cube([thick, height_2 - 2*thick, height_0]);
    difference()
    {
        translate([0, height_2 - 3*thick, thick]) cube([width, thick, 50]);
        translate([12, height_2 -3*thick -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
        translate([width-12, height_2 -3*thick -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
    }
    translate([0, height_2 - 3*thick, thick]) cube([4+thick, thick, deep]);
}
else
{
    // supporting wings
    difference()
    {
        cube([width, (height_1 - height_2)/2 + thick, 50]);
        translate([-1, -thick, thick]) cube([width+2, (height_1 - height_2)/2 + thick, 50]);
        for(i= [0:1:Width-1])
        {
            if(Width==1.5 || Width==2.5 || Width==3.5)
            {
                translate([b_width/4*3+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
            }
            else
            {
            translate([b_width/2+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
            }
        }
        translate([12, (height_1 - height_2)/2 -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
        translate([width-12, (height_1 - height_2)/2 -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
    }
    
    
    translate([0, (height_1 - height_2 - 2*thick)/2 + 20, 0])
    {
        difference()
        {
            cube([width, (height_1 - height_2)/2 + thick, 50]);
            translate([-1, -thick, thick]) cube([width+2, (height_1 - height_2)/2 + thick, 50]);
            for(i= [0:1:Width-1])
            {
                if(Width==1.5 || Width==2.5 || Width==3.5)
                {
                    translate([b_width/4*3+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
                }
                else
                {
                    translate([b_width/2+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
                }
            }
            translate([12, (height_1 - height_2)/2 -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
            translate([width-12, (height_1 - height_2)/2 -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
        }
    }
    
    // alignment cylinders
    translate([10, -10, 0]) cylinder(d=7.5, h=2*thick);
    translate([30, -10, 0]) cylinder(d=7.5, h=2*thick);
    translate([50, -10, 0]) cylinder(d=7.5, h=2*thick);
    translate([70, -10, 0]) cylinder(d=7.5, h=2*thick);
}
