$fa=0.5;
$fs=0.5;

/*******************************************************************************
 *		Dimension settings
 *
 *		Choose between Depth=1, 2, 3 and Width=1, 2, 3, 4
 *
 *		Scaling parameters are:
 *					for Depth:	50
 *					for Width:  50.8
 ******************************************************************************/
Depth = 1.5;
Width = 3;
/******************************************************************************
 *      What to print
 *
 *      Choose between:
 *           Full mod = 2
 *           Body only = 1
 *           wings only = 0
 ******************************************************************************/
print_choice = 2;



/* do not modify the value of the following constants */
height_1 = 229;
height_2 = 196;
b_width = 50.8;
width = b_width * Width;
deep = 50 * Depth;
thick = 2;
height_0 = 15;
/*   end constants   */
 

if ((print_choice == 1) || (print_choice == 2))     // body only or full body
{
    // front panel
    difference()
    {
        cube([width, height_2 - 2* thick, thick]);
        translate([width/4, -thick, 25]) rotate([-90, 0, 0]) cylinder(h = height_2, d=3.5);
        translate([width/4*3, -thick, 25]) rotate([-90, 0, 0]) cylinder(h = height_2, d=3.5);

		HEIGHT = height_2 - 2*thick;
		WIDTH = width;
        //***********************************************************************
        // add here any other hole that is needed on the front panel
        //
        // use HEIGHT and WIDTH as dimensions of the panel
        //***********************************************************************
        translate([(width-117)/2, height_2/8, -1]) cube([117, 77, 2*thick]);    // panel
        translate([width/4, height_2/8*6, -1]) cylinder(d=6.2, h=4);                       // on/off switch
        translate([width/4*2, height_2/8*6, -1]) cylinder(d=9.2, h=4);                       // input jack
        translate([width/4*3, height_2/8*6, -1]) cylinder(d=9.2, h=4);                       // input through jack
    }

    //////////////////////////////////  BEGIN OSCILLOSCOPE PANEL
    translate([(width-117)/2, height_2/8, 0])
    {
        translate([0, 77, 3]) rotate([180, 0, 0]) difference()
        {
            // base
            cube([117, 77, 3]); // body
            
            // display
            translate([117-16-71, 8.5, -2]) cube([72, 54.5, 4]); 
            
            // display frame
            translate([36.67, 16.5, 1]) cube([71-12-7, 53.5-6-8, 3]);
            
            // switches
            translate([6.5, 77-19.5-7, -1]) cube([12.7, 7, 5]); // top
            translate([6.5, 77-19.5-7-11-7, -1]) cube([12.7, 7, 5]); // middle
            translate([6.5, 77-19.5-7-11-7-11-7, -1]) cube([12.7, 7, 5]); // bottom
            
            // buttons
            translate([117-5.6-6, 14.7+6+6.7+6+6.8+6+6.8, -1]) cube([6,6,5]);  //ok
            translate([117-5.6-6, 14.7+6+6.7+6+6.8, -1]) cube([6,6,5]);  // +
            translate([117-5.6-6, 14.7+6+6.7, -1]) cube([6,6,5]);  // -
            translate([117-5.6-6, 14.7, -1]) cube([6,6,5]);  // Mode
            translate([117-17-6, 2, -1]) cube([6,6,5]);  // Reset
        }

        // screw cylinders
         translate([5, 5, 0]) difference()  // botton left
        {
            cylinder(d=6, h=15.7);
            cylinder(d=3, h=17.7);
        }
         translate([117-5, 5, 0]) difference()  // bottom right
        {
            cylinder(d=6, h=15.7);
            cylinder(d=3, h=17.7);
        }
         translate([5, 77-5, 0]) difference()  // top left
        {
            cylinder(d=6, h=15.7);
            cylinder(d=3, h=17.7);
        }
         translate([117-5, 77-5, 0]) difference()  // top right
        {
            cylinder(d=6, h=15.7);
            cylinder(d=3, h=17.7);
        }

        // perimeter reinforcement band
        cube([117, 2, 4]);   // top
        translate([0, 77-2, 0]) cube([117, 2, 4]);   // bottom
        translate([117-2,0, 0]) cube([2, 77, 4]);   // right
        //cube([2, 77, 4]);   // left

        // button walls
        translate([117-5.6-7, 14.7+6+6.7+6+6.8+6+9, 0]) difference()    // mode
        {
            cube([8, 8, 7]);
            translate([1, 1, -1]) cube([6, 6,12]);
        }
        translate([117-5.6-7, 14.7+6+6.7+6+9, 0]) difference()    // -
        {
            cube([8, 8, 7]);
            translate([1, 1, -1]) cube([6, 6,12]);
        }
        translate([117-5.6-7, 14.7+6+8.9, 0]) difference()    // +
        {
            cube([8, 8, 7]);
            translate([1, 1, -1]) cube([6, 6,12]);
        }
        translate([117-5.6-7, 16.9, 0]) difference()    // ok
        {
            cube([8, 8, 7]);
            translate([1, 1, -1]) cube([6, 6,12]);
        }
        translate([117-17-7, 77-1-8, 0]) difference()    // reset
        {
            cube([8, 8, 7]);
            translate([1, 1, -1]) cube([6, 6,12]);
        }
    }
    //////////////////////////////////  END OSCILLOSCOPE PANEL

    // body
    difference()
    {
        translate([0, 0, thick]) cube([width, thick, 50]);
        if (print_choice != 2)
        {
            translate([12, -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
            translate([width-12, -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
        }
    }
    translate([0, 0, thick]) cube([4+thick, thick, deep]);
    translate([4, 0, 0]) difference()
    {
        translate([0, 0, thick]) cube([thick, height_2 - 2*thick, deep]);

		S_HEIGHT = height_2 - 2*thick;
		S_WIDTH =  deep;
        //************************************************************************
        // add here any screw hole needed to support the PCB
        //
        // use S_HEIGHT and S_WIDTH as dimensions of the side panel
        //************************************************************************
       translate([-1, S_HEIGHT-20, S_WIDTH-10])  rotate([0, 90, 0]) cylinder(d=2.5, h= 2*thick);
       translate([-1, S_HEIGHT-20-56.5, S_WIDTH-10])  rotate([0, 90, 0]) cylinder(d=2.5, h= 2*thick);
       translate([-1, S_HEIGHT-20, S_WIDTH-10-36.5])  rotate([0, 90, 0]) cylinder(d=2.5, h= 2*thick);
       translate([-1, S_HEIGHT-20-56.5, S_WIDTH-10-36.5])  rotate([0, 90, 0]) cylinder(d=2.5, h= 2*thick);
    }
    translate([width-thick-4, 0, thick]) cube([thick, height_2 - 2*thick, height_0]);
    difference()
    {
        translate([0, height_2 - 3*thick, thick]) cube([width, thick, 50]);
        if (print_choice != 2)
        {    
            translate([12, height_2 -3*thick -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
            translate([width-12, height_2 -3*thick -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
        }
    }
    translate([0, height_2 - 3*thick, thick]) cube([4+thick, thick, deep]);
}
else if (print_choice == 0)         // wings only
{
    // supporting wings
    difference()
    {
        cube([width, (height_1 - height_2)/2 + thick, 50]);
        translate([-1, -thick, thick]) cube([width+2, (height_1 - height_2)/2 + thick, 50]);
        for(i= [0:1:Width-1])
        {
            if(Width==1.5 || Width==2.5 || Width==3.5)
            {
                translate([b_width/4*3+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
            }
            else
            {
            translate([b_width/2+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
            }
        }
        translate([12, (height_1 - height_2)/2 -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
        translate([width-12, (height_1 - height_2)/2 -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
    }
    
    
    translate([0, (height_1 - height_2 - 2*thick)/2 + 20, 0])
    {
        difference()
        {
            cube([width, (height_1 - height_2)/2 + thick, 50]);
            translate([-1, -thick, thick]) cube([width+2, (height_1 - height_2)/2 + thick, 50]);
            for(i= [0:1:Width-1])
            {
                if(Width==1.5 || Width==2.5 || Width==3.5)
                {
                    translate([b_width/4*3+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
                }
                else
                {
                    translate([b_width/2+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
                }
            }
            translate([12, (height_1 - height_2)/2 -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
            translate([width-12, (height_1 - height_2)/2 -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
        }
    }

    // alignment cylinders
    if (print_choice != 2)
    translate([10, -10, 0]) cylinder(d=7.5, h=2*thick);
    translate([30, -10, 0]) cylinder(d=7.5, h=2*thick);
    translate([50, -10, 0]) cylinder(d=7.5, h=2*thick);
    translate([70, -10, 0]) cylinder(d=7.5, h=2*thick);
}

if (print_choice == 2)      // add wings to full body
{
    // supporting wings
    translate([0, -((height_1 - height_2)/2 + thick), 0]) difference()
    {
        cube([width, (height_1 - height_2)/2 + thick, 50]);
        translate([-1, -thick, thick]) cube([width+2, (height_1 - height_2)/2 + thick, 50]);
        for(i= [0:1:Width-1])
        {
            if(Width==1.5 || Width==2.5 || Width==3.5)
            {
                translate([b_width/4*3+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
            }
            else
            {
            translate([b_width/2+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
            }
        }
    }
    
    translate([0, (height_1 - height_2 - 2*thick)/2, 0])
    {
        rotate([0, 0, 180]) translate([-width, -height_2, 0]) difference()
        {
            cube([width, (height_1 - height_2)/2 + thick, 50]);
            translate([-1, -thick, thick]) cube([width+2, (height_1 - height_2)/2 + thick, 50]);
            for(i= [0:1:Width-1])
            {
                if(Width==1.5 || Width==2.5 || Width==3.5)
                {
                    translate([b_width/4*3+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
                }
                else
                {
                    translate([b_width/2+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
                }
            }
        }
    }
   
 }
 