$fa=0.5;
$fs=0.5;

/*******************************************************************************
 *		Dimension settings
 *
 *		Choose between Depth=1, 2, 3 and Width=1, 2, 3, 4
 *
 *		Scaling parameters are:
 *					for Depth:	50
 *					for Width:  50.8
 ******************************************************************************/
Depth = 2.6;
Width = 2;
/******************************************************************************
 *      What to print
 *
 *      Choose between:
 *           Full mod = 2
 *           Body only = 1
 *           wings only = 0
 ******************************************************************************/
print_choice = 2;



/* do not modify the value of the following constants */
height_1 = 229;
height_2 = 196;
b_width = 50.8;
width = b_width * Width;
deep = 50 * Depth;
thick = 2;
height_0 = 15;
/*   end constants   */

/* new constants */
centre_w = width/2;
centre_h = 28;
centre_line_h = 68;
centre_usb = centre_w-13.6/2;
bottom_line_h =  height_2 - 2*thick-22;

if ((print_choice == 1) || (print_choice == 2))     // body only or full body
{
    // front panel
    difference()
    {
        cube([width, height_2 - 2* thick, thick]);
        translate([width/4, -thick, 25]) rotate([-90, 0, 0]) cylinder(h = height_2, d=3.5);
        translate([width/4*3, -thick, 25]) rotate([-90, 0, 0]) cylinder(h = height_2, d=3.5);

		HEIGHT = height_2 - 2*thick;
		WIDTH = width;
        //***********************************************************************
        // add here any other hole that is needed on the front panel
        //
        // use HEIGHT and WIDTH as dimensions of the panel
        //***********************************************************************
        /*** LCD ***/
        translate([centre_w-72/2, centre_h-25.5/2, -1]) cube([72, 25.5, thick+2]);

        /*** push buttons ***/
        translate([centre_w, centre_line_h, -1]) cylinder(d=7.2, h=thick+2);
        translate([centre_w-10, centre_line_h, -1]) cylinder(d=7.2, h=thick+2);
        translate([centre_w-25.5, centre_line_h, -1]) cylinder(d=7.2, h=thick+2);
        translate([centre_w+10, centre_line_h, -1]) cylinder(d=7.2, h=thick+2);
        translate([centre_w+25.5, centre_line_h, -1]) cylinder(d=7.2, h=thick+2);
        translate([centre_w, centre_line_h-10, -1]) cylinder(d=7.2, h=thick+2);
        translate([centre_w, centre_line_h+10, -1]) cylinder(d=7.2, h=thick+2);
               
        /*** USB sockets ***/
        translate([centre_usb, bottom_line_h, -1]) cube([13.6, 6.2, thick+2]);
        translate([centre_usb-25.4, bottom_line_h, -1]) cube([13.6, 6.2, thick+2]);
        translate([centre_usb+25.4, bottom_line_h, -1]) cube([13.6, 6.2, thick+2]);
                      
         /*** jack sockets ***/
         cd = WIDTH/4-5;
        translate([centre_w-cd*1.5, 102, -1]) cylinder(d=9.5, h=thick+2);      // CV
        translate([centre_w-cd/2, 102, -1]) cylinder(d=9.5, h=thick+2);        // velocity
        translate([centre_w+cd/2, 102, -1]) cylinder(d=9.5, h=thick+2);       // gate
         translate([centre_w+cd*1.5, 102, -1]) cylinder(d=9.5, h=thick+2);   // trigger
         
        translate([centre_w-cd*1.5, 122, -1]) cylinder(d=9.5, h=thick+2);    // A
        translate([centre_w-cd/2, 122, -1]) cylinder(d=9.5, h=thick+2);      // B
        translate([centre_w+cd/2, 122, -1]) cylinder(d=9.5, h=thick+2);     // C
        translate([centre_w+cd*1.5, 122, -1]) cylinder(d=9.5, h=thick+2);   //D
        translate([centre_w-cd*1.5, 142, -1]) cylinder(d=9.5, h=thick+2);    // E
        translate([centre_w-cd/2, 142, -1]) cylinder(d=9.5, h=thick+2);      // F
        translate([centre_w+cd/2, 142, -1]) cylinder(d=9.5, h=thick+2);     // G
        translate([centre_w+cd*1.5, 142, -1]) cylinder(d=9.5, h=thick+2);   //H
    }

    //Screw supports for front panel
    
    // LCD
    difference()
    {
        translate([centre_w-75.40/2, centre_h-31.40/2,0]) cylinder(d=4, h=thick+6);
        translate([centre_w-75.40/2, centre_h-31.40/2,thick]) cylinder(d=2, h=thick+6);
    }
    difference()
    {
        translate([centre_w-75.40/2, centre_h+31.40/2,0]) cylinder(d=4, h=thick+6);
        translate([centre_w-75.40/2, centre_h+31.40/2,thick]) cylinder(d=2, h=thick+6);
    }
    difference()
    {
        translate([centre_w+75.40/2, centre_h-31.40/2,0]) cylinder(d=4, h=thick+6);
        translate([centre_w+75.40/2, centre_h-31.40/2,thick]) cylinder(d=2, h=thick+6);
    }
    difference()
    {
        translate([centre_w+75.40/2, centre_h+31.40/2,0]) cylinder(d=4, h=thick+6);
        translate([centre_w+75.40/2, centre_h+31.40/2,thick]) cylinder(d=2, h=thick+6);
    }
    
    // Push buttons
    difference()
    {
        translate([centre_w-32, centre_line_h+12, 0]) cylinder(d=4, h=thick+7);
         translate([centre_w-32, centre_line_h+12, thick]) cylinder(d=2, h=thick+7);
    }
    difference()
    {
        translate([centre_w-32, centre_line_h-14.5, 0]) cylinder(d=4, h=thick+7);
        translate([centre_w-32, centre_line_h-14.5, thick]) cylinder(d=2, h=thick+7);
    }
    difference()
    {
        translate([centre_w+34.5, centre_line_h+12, 0]) cylinder(d=4, h=thick+7);
        translate([centre_w+34.5, centre_line_h+12, thick]) cylinder(d=2, h=thick+7);
    }
    difference()
    {
        translate([centre_w+34.5, centre_line_h-14.5, 0]) cylinder(d=4, h=thick+7);
        translate([centre_w+34.5, centre_line_h-14.5, thick]) cylinder(d=2, h=thick+7);
    }
        
    // USB sockets
    difference()
    {
        translate([centre_usb-26.4, bottom_line_h-13,0]) cylinder(d=5, h=thick+15);
        translate([centre_usb-26.4, bottom_line_h-13,thick]) cylinder(d=2, h=thick+15);
    }
    difference()
    {
        translate([centre_usb+26.4+13.6, bottom_line_h-13, 0]) cylinder(d=5, h=thick+15);
        translate([centre_usb+26.4+13.6, bottom_line_h-13, thick]) cylinder(d=2, h=thick+15);
    }
    difference()
    {
        translate([centre_usb-26.4, bottom_line_h+13, 0]) cylinder(d=5, h=thick+15);
        translate([centre_usb-26.4, bottom_line_h+13, thick]) cylinder(d=2, h=thick+15);
    }
    difference()
    {
        translate([centre_usb+26.4+13.6, bottom_line_h+13, 0]) cylinder(d=5, h=thick+15);
        translate([centre_usb+26.4+13.6, bottom_line_h+13, thick]) cylinder(d=2, h=thick+15);
    }

    // body
    difference()
    {
        translate([0, 0, thick]) cube([width, thick, 50]);
        if (print_choice != 2)
        {
            translate([12, -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
            translate([width-12, -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
        }
    }
    translate([0, 0, thick]) cube([4+thick, thick, deep]);
    translate([4, 0, 0]) difference()
    {
        translate([0, 0, thick]) cube([thick, height_2 - 2*thick, deep]);

		S_HEIGHT = height_2 - 2*thick;
		S_WIDTH =  deep;
        //************************************************************************
        // add here any screw hole needed to support the PCB
        //
        // use S_HEIGHT and S_WIDTH as dimensions of the side panel
        //************************************************************************
        /*** PCB ***/
        pcb_w = 100;
        pcb_h = 96;
        translate([-1, S_HEIGHT-12, S_WIDTH-5]) rotate([0, 90, 0]) cylinder(d=3.5, h=thick+2);
        translate([-1, S_HEIGHT-12, S_WIDTH-5-pcb_h]) rotate([0, 90, 0]) cylinder(d=3.5, h=thick+2);
        translate([-1, S_HEIGHT-12-pcb_w, S_WIDTH-5]) rotate([0, 90, 0]) cylinder(d=3.5, h=thick+2);
        translate([-1, S_HEIGHT-12-pcb_w, S_WIDTH-5-pcb_h]) rotate([0, 90, 0]) cylinder(d=3.5, h=thick+2);
        /*** Arduino DUE ***/
        translate([-1, 48.26+20, S_WIDTH-25]) rotate([0, 90, 0]) cylinder(d=3.5, h=thick+2);
        translate([-1, 48.26+20, S_WIDTH-25-75.55]) rotate([0, 90, 0]) cylinder(d=3.5, h=thick+2);
        translate([-1, 20, S_WIDTH-25-82.55]) rotate([0, 90, 0]) cylinder(d=3.5, h=thick+2);
        translate([-1, 20, S_WIDTH-25]) rotate([0, 90, 0]) cylinder(d=3.5, h=thick+2);
    }
    translate([width-thick-4, 0, thick]) cube([thick, height_2 - 2*thick, height_0]);
    difference()
    {
        translate([0, height_2 - 3*thick, thick]) cube([width, thick, 50]);
        if (print_choice != 2)
        {    
            translate([12, height_2 -3*thick -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
            translate([width-12, height_2 -3*thick -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
        }
    }
    translate([0, height_2 - 3*thick, thick]) cube([4+thick, thick, deep]);
}
else if (print_choice == 0)         // wings only
{
    // supporting wings
    difference()
    {
        cube([width, (height_1 - height_2)/2 + thick, 50]);
        translate([-1, -thick, thick]) cube([width+2, (height_1 - height_2)/2 + thick, 50]);
        for(i= [0:1:Width-1])
        {
            if(Width==1.5 || Width==2.5 || Width==3.5)
            {
                translate([b_width/4*3+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
            }
            else
            {
            translate([b_width/2+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
            }
        }
        translate([12, (height_1 - height_2)/2 -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
        translate([width-12, (height_1 - height_2)/2 -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
    }
    
    
    translate([0, (height_1 - height_2 - 2*thick)/2 + 20, 0])
    {
        difference()
        {
            cube([width, (height_1 - height_2)/2 + thick, 50]);
            translate([-1, -thick, thick]) cube([width+2, (height_1 - height_2)/2 + thick, 50]);
            for(i= [0:1:Width-1])
            {
                if(Width==1.5 || Width==2.5 || Width==3.5)
                {
                    translate([b_width/4*3+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
                }
                else
                {
                    translate([b_width/2+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
                }
            }
            translate([12, (height_1 - height_2)/2 -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
            translate([width-12, (height_1 - height_2)/2 -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
        }
    }

    // alignment cylinders
    if (print_choice != 2)
    translate([10, -10, 0]) cylinder(d=7.5, h=2*thick);
    translate([30, -10, 0]) cylinder(d=7.5, h=2*thick);
    translate([50, -10, 0]) cylinder(d=7.5, h=2*thick);
    translate([70, -10, 0]) cylinder(d=7.5, h=2*thick);
}

if (print_choice == 2)      // add wings to full body
{
    // supporting wings
    translate([0, -((height_1 - height_2)/2 + thick), 0]) difference()
    {
        cube([width, (height_1 - height_2)/2 + thick, 50]);
        translate([-1, -thick, thick]) cube([width+2, (height_1 - height_2)/2 + thick, 50]);
        for(i= [0:1:Width-1])
        {
            if(Width==1.5 || Width==2.5 || Width==3.5)
            {
                translate([b_width/4*3+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
            }
            else
            {
            translate([b_width/2+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
            }
        }
    }
    
    translate([0, (height_1 - height_2 - 2*thick)/2, 0])
    {
        rotate([0, 0, 180]) translate([-width, -height_2, 0]) difference()
        {
            cube([width, (height_1 - height_2)/2 + thick, 50]);
            translate([-1, -thick, thick]) cube([width+2, (height_1 - height_2)/2 + thick, 50]);
            for(i= [0:1:Width-1])
            {
                if(Width==1.5 || Width==2.5 || Width==3.5)
                {
                    translate([b_width/4*3+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
                }
                else
                {
                    translate([b_width/2+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
                }
            }
        }
    }
   
 }
 