// Theremin box cover
$fa=0.5;
$fs=0.5;

lx=200;	// internal x length
lye=5;		// extention length
ly=180;	// internal y length
lz=80;		// internal z length
th=3;		// walls thickness
wr=10;		// walls reinforcements thickness
wrf=wr+30;	// front wall reinforcemente distance from edge
wrb=ly+2*th-lye-30;	// back wall reinforcement distance from edge


translate([0, 0, lz+th]) rotate([180,0,0]) union()
{
	// main body
	difference()
	{
		cube([lx+2*th, ly+2*th+2*lye, lz+th]);
		translate([th, -1, -1]) cube([lx, ly+2*th+2*lye+2, lz+1]);
		
		translate([-1, 90+lye, lz/2]) rotate([0, 90, 0]) cylinder(h=5, d=33.5);
		translate([lx+th-1, 80+lye, lz/2]) rotate([0, 90, 0]) cylinder(h=5, d=13.5);
		translate([lx+th-1, 130+lye, lz/2]) rotate([0, 90, 0]) cylinder(h=5, d=13.5);
	}

	// wall reinforcements
	translate([th, wrf, 3]) cube([wr, wr, lz]);
	translate([ly+th+wr, wrf, 3]) cube([wr, wr, lz]);
	translate([th, wrb, 3]) cube([wr, wr, lz]);
	translate([ly+th+wr, wrb, 3]) cube([wr, wr, lz]);
}