$fa=0.5;
$fs=0.5;

// case dimansions
tw = 2;              // wall thickness
hb = 140;         // back height
hf = 60;           // front height
db = 240;        // body depth
wb = 190;         // body width
td = 110;           // top depth


// side walls flat coordinates
coords = [[0,0],[0,hf],[db-td+2*tw,hb],[db+2*tw,hb],[db+2*tw,0]];

// case
difference()                  // base
{
    cube([wb, db, tw]);
    
    // transformer holes
    translate([35,142])
    {
        translate([0, 0, -1]) cylinder(d = 5, h= 2+tw);
        translate([0, 84, -1]) cylinder(d = 5, h= 2+tw);
    }
    // curve tracer main holes
    translate([17, 40, 0])
    {
        translate([0, 0, -1]) cylinder(d = 3, h= 2+tw);
        translate([0, 79, -1]) cylinder(d = 3, h= 2+tw);
        translate([36, 0, -1]) cylinder(d = 3, h= 2+tw);
        translate([36, 79, -1]) cylinder(d = 3, h= 2+tw);
    }
    // current Amplifier holes
    translate([79, 182,0])
    {
        translate([0, 0, -1]) cylinder(d=4, h=2+tw);
        translate([102, 0, -1]) cylinder(d=4, h=2+tw);
        translate([0, 33, -1]) cylinder(d=4, h=2+tw);
        translate([102, 33, -1]) cylinder(d=4, h=2+tw);
    }
    // power supply holes
    translate([83.5, 83.5, 0])
    {
        translate([0, 0, -1]) cylinder(d=4, h=2+tw);
        translate([93, 0, -1]) cylinder(d=4, h=2+tw);
        translate([0, 63, -1]) cylinder(d=4, h=2+tw);
        translate([93, 63, -1]) cylinder(d=4, h=2+tw);
    }
    // measurements unit holes
    translate([90.25, 22, 0])
    {
        translate([0, 0, -1]) cylinder(d=3, h=2+tw);
        translate([79, 0, -1]) cylinder(d=3, h=2+tw);
        translate([0, 36, -1]) cylinder(d=3, h=2+tw);
        translate([79, 36, -1]) cylinder(d=3, h=2+tw);
    }
}
difference()            // back wall
{
    translate([0, db, 0]) cube([wb, tw, hb]); 
    translate([15, db+3, 100]) rotate([90, 0, 0]) cylinder(d=12, h=2+tw);
    translate([55, db+3, 100]) rotate([90, 0, 0]) cylinder(d=12, h=2+tw);
}
difference()           // front wall
{
    translate([0, -tw, 0]) cube([wb, tw, hf]); 
    translate([30, 1, 25]) rotate([90, 0, 0]) cylinder(d=5.5, h=2+tw);
    translate([wb-30, -3, 25-4.6]) cube([14.5, 2+tw, 9.2]);
}
translate([-tw, -tw, 0]) rotate([90, 0, 90]) linear_extrude(height = tw) polygon(coords); // left wall
translate([wb, -tw, 0]) rotate([90, 0, 90]) linear_extrude(height = tw) polygon(coords);  // right wall
// panel supports
translate([0, 233, hb-20]) difference()
{
    cube([8, 8, 20]);
    translate([4, 4, 10]) cylinder(d=3, h=11);
}
translate([182, 233, hb-20]) difference()
{
    cube([8, 8, 20]);
    translate([4, 4, 10]) cylinder(d=3, h=11);
}
translate([0, db-td+3, hb-20]) difference()
{
    cube([8, 8, 20]);
    translate([4, 4, 10]) cylinder(d=3, h=11);
}
translate([182, db-td+3, hb-20]) difference()
{
    cube([8, 8, 20]);
    translate([4, 4, 10]) cylinder(d=3, h=11);
}
translate([0, 0, hf-20]) difference()
{
    cube([8, 8, 20]);
    translate([4, 4, 10]) cylinder(d=3, h=11);
}
translate([182, 0, hf-20]) difference()
{
    cube([8, 8, 20]);
    translate([4, 4, 10]) cylinder(d=3, h=11);
}
// separators
translate([0, 30, 0]) cube([70, 1, 2+tw]);
translate([70, 0, 0]) cube([1, 240, 2+tw]);
translate([0, 130, 0]) cube([70, 1, 2+tw]);
translate([70, 10, 0]) cube([120, 1, 2+tw]);
translate([70, 70, 0]) cube([120, 1, 2+tw]);
translate([70, 160, 0]) cube([120, 1, 2+tw]);

