$fa=0.5;
$fs=0.5;

/*******************************************************************************
 *		Dimension settings
 *
 *		Choose between Depth=1, 2, 3 and Width=1, 2, 3, 4
 *
 *		Scaling parameters are:
 *					for Depth:	50
 *					for Width:  50.8
 ******************************************************************************/
Depth = 2.2;
Width = 1.5;
/******************************************************************************
 *      What to print
 *
 *      Choose between:
 *           Full mod = 2
 *           Body only = 1
 *           wings only = 0
 ******************************************************************************/
print_choice = 2;



/* do not modify the value of the following constants */
height_1 = 229;
height_2 = 196;
b_width = 50.8;
width = b_width * Width;
deep = 50 * Depth;
thick = 2;
height_0 = 15;
/*   end constants   */


if ((print_choice == 1) || (print_choice == 2))     // body only or full body
{
    // front panel
    difference()
    {
        cube([width, height_2 - 2* thick, thick]);
        translate([width/4, -thick, 25]) rotate([-90, 0, 0]) cylinder(h = height_2, d=3.5);
        translate([width/4*3, -thick, 25]) rotate([-90, 0, 0]) cylinder(h = height_2, d=3.5);

		HEIGHT = height_2 - 2*thick;
		WIDTH = width;
        //***********************************************************************
        // add here any other hole that is needed on the front panel
        //
        // use HEIGHT and WIDTH as dimensions of the panel
        //***********************************************************************
        translate([0, 6, 0])
        {
            translate([50.5, 159, -1]) cylinder(d=7.5, h=2*thick);
            translate([26, 135, -1]) cylinder(d=9.5, h=2*thick);
            translate([50.5, 110, -1]) cylinder(d=10.5, h=2*thick);
            translate([50.5, 100, -1]) cylinder(d=4, h=2*thick);
        }
        translate([0, -7, 0])
        {
            translate([26, 86, -1]) cylinder(d=7.5, h=2*thick);
            translate([50.5, 61, -1]) cylinder(d=9.5, h=2*thick);
            translate([26, 37, -1]) cylinder(d=10.5, h=2*thick);
            translate([26, 27, -1]) cylinder(d=4, h=2*thick);
        }
    }


    // body
    difference()
    {
        translate([0, 0, thick]) cube([width, thick, 50]);
        if (print_choice != 2)
        {
            translate([12, -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
            translate([width-12, -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
        }
    }
    translate([0, 0, thick]) cube([4+thick, thick, deep]);
    translate([4, 0, 0]) difference()
    {
        translate([0, 0, thick]) cube([thick, height_2 - 2*thick, deep]);

		S_HEIGHT = height_2 - 2*thick;
		S_WIDTH =  deep;
        //************************************************************************
        // add here any screw hole needed to support the PCB
        //
        // use S_HEIGHT and S_WIDTH as dimensions of the side panel
        //************************************************************************
        translate([-1, (S_HEIGHT-120)/2+4.5, S_WIDTH - 10]) rotate([0, 90, 0]) cylinder(d=4, h=2*thick);
        translate([-1, (S_HEIGHT-120)/2+4.5+110.5, S_WIDTH - 10]) rotate([0, 90, 0]) cylinder(d=4, h=2*thick);
        translate([-1, (S_HEIGHT-120)/2+4.5, S_WIDTH - 10-71]) rotate([0, 90, 0]) cylinder(d=4, h=2*thick);
        translate([-1, (S_HEIGHT-120)/2+4.5+110.5, S_WIDTH - 10-71]) rotate([0, 90, 0]) cylinder(d=4, h=2*thick);
    }
    translate([width-thick-4, 0, thick]) cube([thick, height_2 - 2*thick, height_0]);
    difference()
    {
        translate([0, height_2 - 3*thick, thick]) cube([width, thick, 50]);
        if (print_choice != 2)
        {    
            translate([12, height_2 -3*thick -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
            translate([width-12, height_2 -3*thick -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
        }
    }
    translate([0, height_2 - 3*thick, thick]) cube([4+thick, thick, deep]);
}
else if (print_choice == 0)         // wings only
{
    // supporting wings
    difference()
    {
        cube([width, (height_1 - height_2)/2 + thick, 50]);
        translate([-1, -thick, thick]) cube([width+2, (height_1 - height_2)/2 + thick, 50]);
        for(i= [0:1:Width-1])
        {
            if(Width==1.5 || Width==2.5 || Width==3.5)
            {
                translate([b_width/4*3+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
            }
            else
            {
            translate([b_width/2+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
            }
        }
        translate([12, (height_1 - height_2)/2 -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
        translate([width-12, (height_1 - height_2)/2 -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
    }
    
    
    translate([0, (height_1 - height_2 - 2*thick)/2 + 20, 0])
    {
        difference()
        {
            cube([width, (height_1 - height_2)/2 + thick, 50]);
            translate([-1, -thick, thick]) cube([width+2, (height_1 - height_2)/2 + thick, 50]);
            for(i= [0:1:Width-1])
            {
                if(Width==1.5 || Width==2.5 || Width==3.5)
                {
                    translate([b_width/4*3+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
                }
                else
                {
                    translate([b_width/2+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
                }
            }
            translate([12, (height_1 - height_2)/2 -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
            translate([width-12, (height_1 - height_2)/2 -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
        }
    }

    // alignment cylinders
    if (print_choice != 2)
    translate([10, -10, 0]) cylinder(d=7.5, h=2*thick);
    translate([30, -10, 0]) cylinder(d=7.5, h=2*thick);
    translate([50, -10, 0]) cylinder(d=7.5, h=2*thick);
    translate([70, -10, 0]) cylinder(d=7.5, h=2*thick);
}

if (print_choice == 2)      // add wings to full body
{
    // supporting wings
    translate([0, -((height_1 - height_2)/2 + thick), 0]) difference()
    {
        cube([width, (height_1 - height_2)/2 + thick, 50]);
        translate([-1, -thick, thick]) cube([width+2, (height_1 - height_2)/2 + thick, 50]);
        for(i= [0:1:Width-1])
        {
            if(Width==1.5 || Width==2.5 || Width==3.5)
            {
                translate([b_width/4*3+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
            }
            else
            {
            translate([b_width/2+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
            }
        }
    }
    
    translate([0, (height_1 - height_2 - 2*thick)/2, 0])
    {
        rotate([0, 0, 180]) translate([-width, -height_2, 0]) difference()
        {
            cube([width, (height_1 - height_2)/2 + thick, 50]);
            translate([-1, -thick, thick]) cube([width+2, (height_1 - height_2)/2 + thick, 50]);
            for(i= [0:1:Width-1])
            {
                if(Width==1.5 || Width==2.5 || Width==3.5)
                {
                    translate([b_width/4*3+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
                }
                else
                {
                    translate([b_width/2+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
                }
            }
        }
    }
   
 }
 