$fa=0.5;
$fs=0.5;

/*******************************************************************************
 *		Dimension settings
 *
 *		Choose between Depth=1, 2, 3 and Width=1, 2, 3, 4
 *
 *		Scaling parameters are:
 *					for Depth:	50
 *					for Width:  50.8
 ******************************************************************************/
Depth = 2;
Width = 2;
/******************************************************************************
 *      What to print
 *
 *      Choose between:
 *           Full mod = 2
 *           Body only = 1
 *           wings only = 0
 ******************************************************************************/
print_choice = 2;



/* do not modify the value of the following constants */
height_1 = 229;
height_2 = 196;
b_width =49.5;
width = b_width * Width;
deep = 50 * Depth;
thick = 2;
height_0 = 15;
/*   end constants   */


if ((print_choice == 1) || (print_choice == 2))     // body only or full body
{
    // front panel
    difference()
    {
        cube([width, height_2 - 2* thick, thick]);
        translate([width/4, -thick, 25]) rotate([-90, 0, 0]) cylinder(h = height_2, d=3.5);
        translate([width/4*3, -thick, 25]) rotate([-90, 0, 0]) cylinder(h = height_2, d=3.5);

		HEIGHT = height_2 - 2*thick;
		WIDTH = width;
        //***********************************************************************
        // add here any other hole that is needed on the front panel
        //
        // use HEIGHT and WIDTH as dimensions of the panel
        //***********************************************************************

        //LCD
        translate([(WIDTH-83)/2, height_2 - (20+38), -1]) cube([83, 33, 2*thick]);
        
        // rotary encoder
        translate([WIDTH/2, (height_2 - 111)/3*2+53, -1]) cylinder(d=8, h=4);
        
        // RPi
        translate([(WIDTH-58)/2, 15, -1]) cube([58, 33, 2*thick]);
        
        //jacks
       translate([WIDTH/3*2, (height_2 - 111)/3+43, -1]) cylinder(d=9.5, h=2 * thick);         // left
       translate([WIDTH/3, (height_2 - 111)/3+43, -1]) cylinder(d=9.5, h=2 * thick);             // right
    }
    
    // LCD template
    translate([(width-84)/2, height_2 - (20+38), 0])
    {
        difference()
        {
            cube([84, 38, 2]);
            translate([(84-72)/2, 5, -1]) cube([72, 25, 4]);
        }
        
        translate([2.5+2, 3, 0]) difference()
        {
            cylinder(d=5, h=7.5);
            translate([0, 0, 2]) cylinder(d=3.5, h=7);
        }
        translate([80-2.5+2, 3, 0]) difference()
        {
            cylinder(d=5, h=7.5);
            translate([0, 0, 2]) cylinder(d=3.5, h=7);
        }
        translate([2.5+2, 36-4+2, 0]) difference()
        {
            cylinder(d=5, h=7.5);
            translate([0, 0, 2]) cylinder(d=3.5, h=7);
        }
        translate([80-2.5+2, 36-4+2, 0]) difference()
        {
            cylinder(d=5, h=7.5);
            translate([0, 0, 2]) cylinder(d=3.5, h=7);
        }
        
        translate([(84-72)/2, 4, 0]) cube([72, 1, 4]);
        translate([(84-72)/2, 30, 0]) cube([72, 1, 4]);
        translate([(84-72)/2-1, 5, 0]) cube([1, 26, 4]);
        translate([(84-72)/2+72, 5, 0]) cube([1, 26, 4]);
    }
    
    // RPi template
    translate([80, 15, 0]) rotate([-90, 180, 0])
    {
        difference()
        {
            cube([60, 90, 2]);
            translate([(60-49)/2, 84, -1]) cylinder(d=3.5, h=4);
            translate([60-(60-49)/2, 84, -1]) cylinder(d=3.5, h=4);
            translate([(60-49)/2, 26, -1]) cylinder(d=3.5, h=4);
            translate([60-(60-49)/2, 26, -1]) cylinder(d=3.5, h=4);
            translate([(60-30)/2, 32, -1]) minkowski()
            {
                cube([30, 45, 3]);
                cylinder(d=5, h=1);
            }
        }
        
        cube([2, 90, 8]);
        translate([60-2, 0, 0]) cube([2, 90, 8]);
        translate([0, 90-2, 0]) cube([60, 2, 5]);
        cube([2, 5, 35]);
        translate([60-2, 0, 0]) cube([2, 5, 35]);
        
        difference()
        {
            cube([60, 2, 35]);
            translate([4.5, -1, 13.5]) cube([16, 4, 14.5]);
            translate([23, -1, 13.5]) cube([16, 4, 17]);
            translate([41, -1, 13.5]) cube([16, 4, 17]);
        }
    }

    // body
    difference()
    {
        translate([0, 0, thick]) cube([width, thick, 50]);
        if (print_choice != 2)
        {
            translate([12, -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
            translate([width-12, -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
        }
    }
    translate([0, 0, thick]) cube([4+thick, thick, deep]);
    translate([4, 0, 0]) difference()
    {
        translate([0, 0, thick]) cube([thick, height_2 - 2*thick, deep]);

		S_HEIGHT = height_2 - 2*thick;
		S_WIDTH =  deep;
        //************************************************************************
        // add here any screw hole needed to support the PCB
        //
        // use S_HEIGHT and S_WIDTH as dimensions of the side panel
        //************************************************************************
        translate([thick-3, 60, 40]) rotate([0, 90, 0]) cylinder(d=2.5, h=2*thick);
        translate([thick-3, 104.5, 40]) rotate([0, 90, 0]) cylinder(d=2.5, h=2*thick);
        translate([thick-3, 60, 71.5]) rotate([0, 90, 0]) cylinder(d=2.5, h=2*thick);
        translate([thick-3, 104.5, 71.5]) rotate([0, 90, 0]) cylinder(d=2.5, h=2*thick);

    }
    translate([width-thick-4, 0, thick]) cube([thick, height_2 - 2*thick, height_0]);
    difference()
    {
        translate([0, height_2 - 3*thick, thick]) cube([width, thick, 50]);
        if (print_choice != 2)
        {    
            translate([12, height_2 -3*thick -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
            translate([width-12, height_2 -3*thick -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
        }
    }
    translate([0, height_2 - 3*thick, thick]) cube([4+thick, thick, deep]);
}
else if (print_choice == 0)         // wings only
{
    // supporting wings
    difference()
    {
        cube([width, (height_1 - height_2)/2 + thick, 50]);
        translate([-1, -thick, thick]) cube([width+2, (height_1 - height_2)/2 + thick, 50]);
        for(i= [0:1:Width-1])
        {
            if(Width==1.5 || Width==2.5 || Width==3.5)
            {
                translate([b_width/4*3+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
            }
            else
            {
            translate([b_width/2+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
            }
        }
        translate([12, (height_1 - height_2)/2 -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
        translate([width-12, (height_1 - height_2)/2 -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
    }
    
    
    translate([0, (height_1 - height_2 - 2*thick)/2 + 20, 0])
    {
        difference()
        {
            cube([width, (height_1 - height_2)/2 + thick, 50]);
            translate([-1, -thick, thick]) cube([width+2, (height_1 - height_2)/2 + thick, 50]);
            for(i= [0:1:Width-1])
            {
                if(Width==1.5 || Width==2.5 || Width==3.5)
                {
                    translate([b_width/4*3+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
                }
                else
                {
                    translate([b_width/2+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
                }
            }
            translate([12, (height_1 - height_2)/2 -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
            translate([width-12, (height_1 - height_2)/2 -1, 10]) rotate([-90, 0, 0]) cylinder(d=8.2, h=thick+2);
        }
    }

    // alignment cylinders
    if (print_choice != 2)
    translate([10, -10, 0]) cylinder(d=7.5, h=2*thick);
    translate([30, -10, 0]) cylinder(d=7.5, h=2*thick);
    translate([50, -10, 0]) cylinder(d=7.5, h=2*thick);
    translate([70, -10, 0]) cylinder(d=7.5, h=2*thick);
}

if (print_choice == 2)      // add wings to full body
{
    // supporting wings
    translate([0, -((height_1 - height_2)/2 + thick), 0]) difference()
    {
        cube([width, (height_1 - height_2)/2 + thick, 50]);
        translate([-1, -thick, thick]) cube([width+2, (height_1 - height_2)/2 + thick, 50]);
        for(i= [0:1:Width-1])
        {
            if(Width==1.5 || Width==2.5 || Width==3.5)
            {
                translate([b_width/4*3+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
            }
            else
            {
            translate([b_width/2+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
            }
        }
    }
    
    translate([0, (height_1 - height_2 - 2*thick)/2, 0])
    {
        rotate([0, 0, 180]) translate([-width, -height_2, 0]) difference()
        {
            cube([width, (height_1 - height_2)/2 + thick, 50]);
            translate([-1, -thick, thick]) cube([width+2, (height_1 - height_2)/2 + thick, 50]);
            for(i= [0:1:Width-1])
            {
                if(Width==1.5 || Width==2.5 || Width==3.5)
                {
                    translate([b_width/4*3+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
                }
                else
                {
                    translate([b_width/2+i*b_width, (height_1 - height_2)/4, -1]) cylinder(d=4.5, h=thick + 2);
                }
            }
        }
    }
   
 }
 